#!/usr/bin/env python3
"""
Tailwind Site Rebuilder Web Application
---------------------------------------
A web interface for analyzing websites and creating blueprints for Tailwind CSS rebuilds.
"""

from flask import Flask, render_template, request, redirect, url_for, flash, jsonify, send_from_directory
import os
import json
import sys
import re
from urllib.parse import urlparse
import threading
import time
from datetime import datetime

# Ensure we can import from our lib directory
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), "lib"))

from analyzer import create_simulation, SiteRebuilder

app = Flask(__name__, static_folder='static', template_folder='templates')
app.secret_key = 'tailwind_rebuilder_secret_key'  # For flash messages

# Add context processor to provide current date to all templates
@app.context_processor
def inject_now():
    return {'now': datetime.now()}

# Directory to store analysis results
SITES_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), "sites")
os.makedirs(SITES_DIR, exist_ok=True)

# Track active analyses
active_analyses = {}

# ... rest of the existing code ... 