# Tailwind Site Rebuilder

A streamlined web application for analyzing websites and generating Tailwind CSS rebuild guidance with prompt engineering.

## Overview

This tool analyzes websites by taking screenshots and using advanced analysis techniques (including AI when available) to:

1. Identify page structure and sections
2. Extract color schemes and typography details
3. Provide comprehensive guidance for rebuilding the site with Tailwind CSS
4. Generate detailed AI insights on layout, colors, and components
5. **NEW: Create optimized prompts for AI-assisted site rebuilding**

## Quick Start

### 1. Environment Setup

First, set up your environment variables:

```bash
# Copy the example environment file
cp env_example.txt .env

# Edit .env and add your OpenAI API key (optional but recommended for AI features)
# OPENAI_API_KEY=your_openai_api_key_here
```

### 2. Install Dependencies

```bash
# Create and activate virtual environment
python3 -m venv venv
source venv/bin/activate

# Install required packages
pip install -r requirements.txt
```

### 3. Start the Web Server

```bash
# Source the environment file and run the web server
source .env && python3 run.py
```

The web application will be available at http://localhost:5000

## Files and Structure

The essential files in this application are:

- `run.py` - Main entry point to start the web server
- `app.py` - Flask web application with advanced features
- `main.py` - Command line interface for direct analysis
- `lib/analyzer.py` - Core analysis logic
- `env_example.txt` - Environment configuration template
- `requirements.txt` - Python dependencies
- `output_with_ai/` - Output directory containing results and screenshots
- `venv/` - Python virtual environment with dependencies

## Installation

All dependencies are listed in `requirements.txt`. To start fresh:

```bash
# Create a new virtual environment
python3 -m venv venv

# Activate the environment
source venv/bin/activate

# Install dependencies
pip install -r requirements.txt
```

## Usage

### Running the Web Interface (Recommended)

The easiest way to use this tool is through the web interface:

```bash
# Method 1: Using run.py (recommended)
source .env && python3 run.py

# Method 2: Using the convenience script
./run_webapp.sh
```

Both methods will:
1. Load environment variables from .env file
2. Start the Flask web application on http://localhost:5000

### Manual Analysis

You can also run analyses directly from the command line:

```bash
# With AI verification (if API key is configured)
./demo-verify.sh https://example.com

# Without AI verification
SKIP_AI=1 ./demo-verify.sh https://example.com
```

## Configuration

### Environment Variables

The application uses the following environment variables (configured in `.env`):

- `OPENAI_API_KEY` - Your OpenAI API key for AI-powered analysis (optional)
- `FLASK_SECRET_KEY` - Flask session secret key (optional)
- `PORT` - Port to run the web server on (default: 5000)
- `FLASK_DEBUG` - Enable debug mode (default: False)

### Getting an OpenAI API Key

1. Visit https://platform.openai.com/api-keys
2. Create a new API key
3. Add it to your `.env` file as `OPENAI_API_KEY=your_key_here`

## Output

Analysis results are saved to the `output_with_ai` directory:

- `output_with_ai/rebuild_context.json` - Comprehensive analysis data
- `output_with_ai/screenshots/` - Screenshots of analyzed websites

## Web Interface Features

The web interface provides:

- Simple URL input form
- Option to toggle AI verification
- Tabbed display of analysis results:
  - Overview (site info, general notes)
  - Sections (detailed breakdown of page sections)
  - Design (colors, typography)
  - AI Insights (AI verification and recommendations)
  - **Rebuild Prompts (AI-ready prompts for site rebuilding)**
- Display of the latest screenshot
- Raw JSON data explorer

### New Prompt Engineering Feature

The "Rebuild Prompts" tab allows you to:

1. View and copy complete site rebuild prompts
2. Access component-specific prompts for individual sections
3. Customize prompts by selecting focus areas:
   - Layout Structure
   - Color Scheme
   - Typography
   - Components
   - Responsive Design
4. Regenerate prompts with different focus areas

Each prompt is engineered to contain the precise details needed for accurate site rebuilding with Tailwind CSS.

## Fallback Mechanism

If dependencies are missing, the tool will gracefully fall back to a demo mode that simulates the analysis, ensuring the web interface always works.

## Cleanup

To remove unnecessary files and simplify the directory structure:

```bash
./cleanup_direct.sh
```

This will clean up duplicate directories and unnecessary files while preserving all essential functionality. 