#!/usr/bin/env python3
"""
Run script for the Tailwind Site Rebuilder web application
"""

import os
from app import app

if __name__ == '__main__':
    # Load environment variables from .env file if it exists
    try:
        from dotenv import load_dotenv
        load_dotenv()
    except ImportError:
        pass
    
    # Get port from environment variable or use default
    port = int(os.environ.get('PORT', 5002))
    
    # Set debug mode from environment variable or default to False in production
    debug = os.environ.get('FLASK_DEBUG', 'False').lower() in ('true', '1', 't')
    
    # Run the app
    app.run(host='0.0.0.0', port=port, debug=debug) 