#!/bin/bash

# Make sure demo-verify.sh is executable
chmod +x ./demo-verify.sh

# Create a virtual environment if it doesn't exist
if [ ! -d "venv" ]; then
    echo "Creating Python virtual environment..."
    python3 -m venv venv
fi

# Activate the virtual environment
source venv/bin/activate

# Install required packages
echo "Installing required packages..."
pip install flask requests selenium webdriver-manager Pillow openai python-dotenv

# Make sure output directories exist
mkdir -p output_with_ai/screenshots

# Run the Flask application
echo "Starting Tailwind Site Rebuilder webapp..."
python webapp.py

# Deactivate the virtual environment when done
# This won't actually execute until the Flask app is stopped
deactivate 